namespace Hive.Unity.Editor
{
    using System.Collections.Generic;

    internal partial class XmlAnalytics
    {
        internal Adjust adjust;
        internal Singular singular;
        internal AppsFlyer appsflyer;
        internal Firebase firebase;
        internal Airbridge airbridge;

        internal partial class Adjust
        {
            HiveConfigXmlData data;

            internal string appToken;
            internal List<string> eventKeys;
            internal List<string> eventValues;
        }

        internal partial class Singular
        {
            HiveConfigXmlData data;
            
            internal string appId;
            internal string secret;
            internal List<string> eventKeys;
            internal List<string> eventValues;
        }

        internal partial class AppsFlyer
        {
            HiveConfigXmlData data;
            
            internal string key;
            internal string itunesConnectAppId;
            internal List<string> eventKeys;
            internal List<string> eventValues;
        }

        internal partial class Firebase
        {
            HiveConfigXmlData data;
            
            internal List<string> eventKeys;
            internal List<string> eventValues;
        }

        internal partial class Airbridge
        {
            HiveConfigXmlData data;
            
            internal string key;
            internal string appName;
            internal string secretId;
            internal string secret;
            internal List<string> eventKeys;
            internal List<string> eventValues;
        }
    }





    internal partial class XmlAnalytics
    {
        internal XmlAnalytics(HiveConfigXmlData data)
        {
            adjust = new Adjust(data);
            singular = new Singular(data);
            appsflyer = new AppsFlyer(data);
            firebase = new Firebase(data);
            airbridge = new Airbridge(data);
        }

        internal partial class Adjust
        {
            internal Adjust(HiveConfigXmlData data)
            {
                this.data = data;
                HiveConfigXmlStep.AdjustTracker adjust = (HiveConfigXmlStep.AdjustTracker)data.Xml.Adjust;
                appToken = adjust.key;
                eventKeys = adjust.eventName;
                eventValues = adjust.eventValue;
            }

            internal void Apply()
            {
                HiveConfigXmlStep.AdjustTracker adjust = (HiveConfigXmlStep.AdjustTracker)data.Xml.Adjust;
                adjust.key = appToken;
                adjust.eventName = eventKeys;
                adjust.eventValue = eventValues;
                data.Xml.Adjust = adjust;
            }
        }

        internal partial class Singular
        {
            internal Singular(HiveConfigXmlData data)
            {
                this.data = data;
                HiveConfigXmlStep.SingularTracker singular = (HiveConfigXmlStep.SingularTracker)data.Xml.Singular;
                appId = singular.id;
                secret = singular.key;
                eventKeys = singular.eventName;
                eventValues = singular.eventValue;
            }

            internal void Apply()
            {
                HiveConfigXmlStep.SingularTracker singular = (HiveConfigXmlStep.SingularTracker)data.Xml.Singular;
                singular.id = appId;
                singular.key = secret;
                singular.eventName = eventKeys;
                singular.eventValue = eventValues;
                data.Xml.Singular = singular;
            }
        }

        internal partial class AppsFlyer
        {
            internal AppsFlyer(HiveConfigXmlData data)
            {
                this.data = data;
                HiveConfigXmlStep.AppsFlyerTracker appsflyer = (HiveConfigXmlStep.AppsFlyerTracker)data.Xml.AppsFlyer;
                key = appsflyer.key;
                itunesConnectAppId = appsflyer.itunesConnectAppId;
                eventKeys = appsflyer.eventName;
                eventValues = appsflyer.eventValue;
            }

            internal void Apply()
            {
                HiveConfigXmlStep.AppsFlyerTracker appsflyer = (HiveConfigXmlStep.AppsFlyerTracker)data.Xml.AppsFlyer;
                appsflyer.key = key;
                appsflyer.itunesConnectAppId = itunesConnectAppId;
                appsflyer.eventName = eventKeys;
                appsflyer.eventValue = eventValues;
                data.Xml.AppsFlyer = appsflyer;
            }
        }

        internal partial class Firebase
        {
            internal Firebase(HiveConfigXmlData data)
            {
                this.data = data;
                HiveConfigXmlStep.FirebaseTracker firebase = (HiveConfigXmlStep.FirebaseTracker)data.Xml.Firebase;
                eventKeys = firebase.eventName;
                eventValues = firebase.eventValue;
            }

            internal void Apply()
            {
                HiveConfigXmlStep.FirebaseTracker firebase = (HiveConfigXmlStep.FirebaseTracker)data.Xml.Firebase;
                firebase.eventName = eventKeys;
                firebase.eventValue = eventValues;
                data.Xml.Firebase = firebase;
            }
        }

        internal partial class Airbridge
        {
            internal Airbridge(HiveConfigXmlData data)
            {
                this.data = data;
                HiveConfigXmlStep.AirbridgeTracker airbridge = (HiveConfigXmlStep.AirbridgeTracker)data.Xml.Airbridge;
                key = airbridge.key;
                appName = airbridge.appName;
                secretId = airbridge.secretId;
                secret = airbridge.secret;
                eventKeys = airbridge.eventName;
                eventValues = airbridge.eventValue;
            }

            internal void Apply()
            {
                HiveConfigXmlStep.AirbridgeTracker airbridge = (HiveConfigXmlStep.AirbridgeTracker)data.Xml.Airbridge;
                airbridge.key = key;
                airbridge.appName = appName;
                airbridge.secretId = secretId;
                airbridge.secret = secret;
                airbridge.eventName = eventKeys;
                airbridge.eventValue = eventValues;
                data.Xml.Airbridge = airbridge;
            }
        }
    }
}